/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.routes;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.routes.IVWConditionParameterSource;
import filenet.vw.toolkit.utils.event.IVWPropertyChangeListener;
import filenet.vw.toolkit.utils.event.VWPropertyChangeEvent;
import filenet.vw.toolkit.utils.table.VWLabelListCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class VWFieldPanel
extends JPanel
implements IVWConditionParameterSource,
IVWPropertyChangeListener {
    private JComboBox m_fieldsCombo = null;
    private JComboBox m_operatorsCombo = null;
    private JTextField m_valueTextField = null;
    private Vector m_controls = null;
    private VWAuthPropertyData m_authPropertyData = null;

    public VWFieldPanel(VWAuthPropertyData authPropertyData) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.m_controls = new Vector();
            this.createControls();
            this.reinitialize();
            this.m_authPropertyData.getPropertyChangeEventNotifier().addPropertyChangeListener(this);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void setEnabled(boolean bEnable) {
        JComponent component = null;
        super.setEnabled(bEnable);
        if (this.m_controls == null) {
            return;
        }
        for (int i = 0; i < this.m_controls.size(); ++i) {
            component = (JComponent)this.m_controls.elementAt(i);
            if (component == null) continue;
            component.setEnabled(bEnable);
        }
    }

    public String getConditionString() {
        String fieldString = null;
        int nIndex = -1;
        boolean bIsArray = false;
        String opString = null;
        String valueString = null;
        StringBuffer buffer = null;
        try {
            fieldString = (String)this.m_fieldsCombo.getSelectedItem();
            if (fieldString != null && (nIndex = fieldString.indexOf(" (")) != -1) {
                String tempString = fieldString.substring(nIndex + 2, fieldString.length() - 1);
                if (tempString != null) {
                    bIsArray = tempString.lastIndexOf("[]") != -1;
                }
                fieldString = fieldString.substring(0, nIndex);
                if (bIsArray) {
                    fieldString = fieldString + "[1]";
                }
            }
            if ((opString = (String)this.m_operatorsCombo.getSelectedItem()).equals(VWResource.s_isEqualOp)) {
                opString = " = ";
            } else if (opString.equals(VWResource.s_notEqualOp)) {
                opString = " <> ";
            } else if (opString.equals(VWResource.s_isGreaterThanOp)) {
                opString = " > ";
            } else if (opString.equals(VWResource.s_isGreaterThanOrEqualOp)) {
                opString = " >= ";
            } else if (opString.equals(VWResource.s_isLessThanOp)) {
                opString = " < ";
            } else if (opString.equals(VWResource.s_isLessThanOrEqualOp)) {
                opString = " <= ";
            }
            valueString = this.m_valueTextField.getText();
            buffer = new StringBuffer();
            buffer.append(fieldString);
            buffer.append(opString);
            buffer.append(valueString);
            return buffer.toString();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public void propertyChange(VWPropertyChangeEvent event) {
        switch (event.getID()) {
            case 506: 
            case 507: 
            case 508: 
            case 509: 
            case 511: 
            case 512: 
            case 513: 
            case 514: 
            case 558: 
            case 559: 
            case 560: 
            case 561: 
            case 563: 
            case 564: 
            case 565: 
            case 566: {
                this.reinitialize();
            }
        }
    }

    protected void releaseReferences() {
        this.m_authPropertyData.getPropertyChangeEventNotifier().removePropertyChangeListener(this);
        if (this.m_fieldsCombo != null) {
            this.m_fieldsCombo.removeAll();
            this.m_fieldsCombo = null;
        }
        if (this.m_operatorsCombo != null) {
            this.m_operatorsCombo.removeAll();
            this.m_operatorsCombo = null;
        }
        if (this.m_valueTextField != null) {
            this.m_valueTextField.removeAll();
            this.m_valueTextField = null;
        }
        if (this.m_controls != null) {
            this.m_controls.removeAllElements();
            this.m_controls = null;
        }
        this.m_authPropertyData = null;
    }

    private void createControls() {
        try {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.anchor = 21;
            gbCons.gridwidth = -1;
            gbCons.gridheight = 1;
            gbCons.insets = new Insets(4, 4, 4, 4);
            JLabel label = new JLabel(VWResource.s_fieldStr);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_fieldsCombo = new JComboBox();
            this.m_fieldsCombo.setRenderer(new VWLabelListCellRenderer());
            this.add((Component)this.m_fieldsCombo, gbCons);
            this.m_controls.addElement(this.m_fieldsCombo);
            gbCons.gridwidth = -1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_operatorStr);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_operatorsCombo = new JComboBox();
            this.m_operatorsCombo.setRenderer(new VWLabelListCellRenderer());
            this.m_operatorsCombo.addItem(VWResource.s_isEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_notEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isGreaterThanOrEqualOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOp);
            this.m_operatorsCombo.addItem(VWResource.s_isLessThanOrEqualOp);
            this.m_controls.addElement(this.m_operatorsCombo);
            this.add((Component)this.m_operatorsCombo, gbCons);
            gbCons.gridwidth = -1;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            label = new JLabel(VWResource.s_value);
            this.m_controls.addElement(label);
            this.add((Component)label, gbCons);
            gbCons.gridwidth = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            this.m_valueTextField = new JTextField(10);
            this.m_controls.addElement(this.m_valueTextField);
            this.add((Component)this.m_valueTextField, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void reinitialize() {
        this.initializeComboBox(this.m_fieldsCombo, this.getFieldNames(true));
        this.m_valueTextField.setText("");
    }

    private String[] getFieldNames(boolean bShowType) {
        VWFieldDefinition[] vwFieldDefs = null;
        Vector<String> fieldNames = null;
        String fieldName = null;
        Object[] items = null;
        try {
            if (this.m_authPropertyData.getWorkflowDefinition() == null) {
                return null;
            }
            vwFieldDefs = this.m_authPropertyData.getFields();
            if (vwFieldDefs == null) {
                return null;
            }
            fieldNames = new Vector<String>();
            for (int i = 0; i < vwFieldDefs.length; ++i) {
                fieldName = vwFieldDefs[i].getName();
                if (fieldName.equals("F_Trackers")) continue;
                if (bShowType) {
                    String fieldType = VWFieldType.getLocalizedString(vwFieldDefs[i].getFieldType());
                    fieldName = vwFieldDefs[i].isArray() ? fieldName.concat(" (" + fieldType + "[])") : fieldName.concat(" (" + fieldType + ")");
                }
                fieldNames.addElement(fieldName);
            }
            items = new String[fieldNames.size()];
            fieldNames.copyInto(items);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return items;
    }

    private void initializeComboBox(JComboBox comboBox, String[] items) {
        try {
            DefaultComboBoxModel dataModel = (DefaultComboBoxModel)comboBox.getModel();
            if (dataModel.getSize() > 0) {
                dataModel.removeAllElements();
            }
            if (items != null) {
                for (int i = 0; i < items.length; ++i) {
                    dataModel.addElement(items[i]);
                }
            }
            if (comboBox.getItemCount() > 0) {
                comboBox.setSelectedIndex(0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

